#include <iostream>
using namespace std;

class tAuto
{
public:
    tAuto() { Kennzeichen=0; Raeder=4; }
    ~tAuto() { delete Kennzeichen; Kennzeichen = 0; }
    void SetKennzeichen(char *a);
    char *GetKennzeichen() const { return Kennzeichen; }
    tAuto(const tAuto& k);
    tAuto &operator=(const tAuto &k);

    int Raeder;
private:
    int StringLaenge(char *s)
    {
        int len=0;
        while (*s++) len++;
        return len+1;
    }
    void StringKopie(char *Quelle)
    {
        char *Ziel = Kennzeichen;
        while (*Quelle) *Ziel++ = *Quelle++;
        *Ziel=0; // Abschluss-Null
    }
    char *Kennzeichen;
};

void tAuto::SetKennzeichen(char *Kz)
{
    int len = StringLaenge(Kz);
    if (Kennzeichen) delete Kennzeichen;
    Kennzeichen = new char[len];
    StringKopie(Kz);
}

tAuto::tAuto(const tAuto& k)
{
    cout << "Kopierkonstruktor" << endl;
    int len = StringLaenge(k.GetKennzeichen());
    Kennzeichen = new char[len];
    StringKopie(k.GetKennzeichen());
    Raeder = k.Raeder;
}

tAuto &tAuto::operator=(const tAuto &k)
{
    if (this != &k)
    // wenn es keine Zuweisung an sich selbst ist
    {
        cout << "Zuweisung:" << k.GetKennzeichen() << endl;
        // lsche bisherige Daten
        delete Kennzeichen;
        // ... und lege neuen Datenbereich an
        int len = StringLaenge(k.GetKennzeichen());
        Kennzeichen = new char[len];
        // kopieren der Daten
        StringKopie(k.GetKennzeichen());
        Raeder = k.Raeder;
    }
    return *this;
}

tAuto Uebergebe(tAuto para)
{
    cout << "Funktion:" << para.GetKennzeichen() << endl;
    return para;
}

int main()
{
    tAuto Objekt;
    tAuto Ziel;
    Objekt.SetKennzeichen("HG-AW 409");
    Ziel = Uebergebe(Objekt);
    cout << Objekt.GetKennzeichen() << endl;
    cout << Ziel.GetKennzeichen() << endl;
}

