// Programm zur Demonstration einer Stack-Klasse
#include <iostream>
using namespace std;

// Knoten einer verketteten Liste
class tNode
{
public:
    int d;       // Daten, hier ganze Zahlen
    tNode *next; // Verkettung
};

// Der Stack als Verbindung aus Anker und Operationen
class tStack
{
public:
    tStack();
    ~tStack();
    void push(int); // fgt Informationen hinzu
    int pop();      // holt Informationen heraus
private:
    tNode * Anker;  // jeder Stack hat seinen eigenen Anker
};

tStack::tStack()
{
    Anker = 0;      // leere Liste wird vorbereitet
}

// Der Destruktor lscht alle briggebliebenen Elemente
tStack::~tStack()
{
    tNode *last = Anker;  // Hilfszeiger zum Sichern des Ankers
    while (Anker)         // solange noch Elemente in der Liste
    {
        last = Anker;        // erstes Element sichern
        Anker = Anker->next; // Anker auf zweites Element setzen
        delete last;         // erstes Element freigeben
    }
}

// Neues Element vorn in die Liste einhngen
void tStack::push(int d)
{
    tNode *node = new tNode; // erzeugt Listenelement
    node->d = d;             // besetzt das Datenfeld
    node->next = Anker;      // hnge bisherige Liste an
    Anker = node;            // Mache dieses Element zum Anker
}

// Oberstes Element auslesen und aus der Liste lschen
int tStack::pop()
{
    int inhalt=0; // Hilfsvariable vom Typ der Elementdaten
    if (Anker)    // sofern die Liste nicht schon leer ist
    {
        tNode *old = Anker;  // sichere erstes Element
        Anker = Anker->next; // setze Anker auf zweites Element
        inhalt = old->d;     // kopiere den Knoteninhalt
        delete old;          // gebe den ausgelesenen Knoten frei
    }
    return inhalt;           // liefere den Knoteninhalt
}

// Hauptprogramm zum Testen des Stacks
int main()
{
    tStack stack;   // lege einen Stack an
    stack.push(2);  // schiebe Testdaten darauf
    stack.push(5);
    stack.push(18);
    cout << stack.pop() << endl; // lese den Stack aus
    cout << stack.pop() << endl; 
    cout << stack.pop() << endl; 
}

