#include <iostream>
using namespace std;

// tNode beschreibt einen Knoten mit Daten und einem Zeiger
// auf das nchste Element. Da es eine Template-Klasse ist,
// knnen spter beliebige Datentypen verwendet werden.
template<class T> class tNode
{
public:
    T data;
    tNode<T> *next;
};

template<class T> class Stack
{
public:
    Stack() { Anker = 0; }
    ~Stack();
    bool pop(T *); // Daten auf dem Stack ablegen
    bool push(T ); // Daten vom Stack entnehmen
private:
    tNode<T> *Anker; // Basis fr den Stack
};

// Der Destruktor gibt verbliebene Knoten frei
template<class T> Stack<T>::~Stack()
{
    tNode<T> *Loeschkandidat;
    while (Anker) // solange noch Knoten im Stack
    {
        Loeschkandidat = Anker; // Zum Lschen sichern
        Anker = Anker->next;    // Kopf auf zweiten Knoten
        delete Loeschkandidat;  // Nun gefahrlos lschen
    }
}

// Element vom Stack abziehen
template<class T> bool Stack<T>::pop(T *get)
{
    if (Anker) // wenn noch ein Knoten auf dem Stack liegt
    {
        tNode<T> *old = Anker; // Sichern des ersten Knotens
        Anker = Anker->next;   // Kopf auf zweiten Knoten setzen
        *get = old->data;      // Daten an Aufrufer geben
        delete old;            // Knoten freigeben
        return true;
    }
    return false;
}

// Element auf den Stack legen
template<class T> bool Stack<T>::push(T NeuData)
{
    tNode<T> *node = new tNode<T>; // Neuen Knoten anlegen
    node->data = NeuData;          // mit Daten fllen
    node->next = Anker;            // Bisherigen Stack anhngen
    Anker = node;          // Neuer Knoten wird Kopf des Stacks
    return true;
}

int main() // Stack testen
{
   Stack<int> iStack; // Integer-Stack anlegen
   int a;             // Fr die Datenentnahme
   iStack.push(8);    // Auffllen
   iStack.push(4);
   iStack.push(2);
   // Ausgeben des Stackinhalts
   for (int i=0; i<3; i++)
   {
       if (iStack.pop(&a))
       {
           cout << a << endl;
       }
   }
}

