// Programm zur Demonstration eines Kopierkonstruktors
#include <iostream>
using namespace std;

class tKlasse
{
public:
    tKlasse() // Konstruktor: erzeugt externe Daten
    {
        Zeiger = new int(0);
    }
    ~tKlasse() // Destruktor: gibt externe Daten frei
    {
        // *Zeiger = 9; // nur zum Test
        delete Zeiger;
        Zeiger = 0;
    }
    void SetData(int a) { *Zeiger = a; }
    int GetData() const { return *Zeiger; }
    tKlasse(const tKlasse& k) // Kopierkonstruktor
    {
        // zur Demonstration meldet er sich
        cout << "Kopierkonstruktor" << endl;
        // Externe Daten erzeugen und kopieren
        Zeiger = new int(0);
        *Zeiger = k.GetData();
        // Normale Datenelemente auch kopieren
        sonstiges = k.sonstiges;
    }
    int sonstiges; // steht fr die Nicht-Zeiger Datenelemente
private:
    int *Zeiger;   // Zeiger, also Kopierkonstruktor
};

// Die Funktion dient nur zur Demonstration. Weil der Parameter
// per Wert bergeben wird, wird beim Aufruf der
// Kopierkonstruktor aufgerufen
void Funktion(tKlasse para)
{
    cout << "Funktion:" << para.GetData() << endl;
}

// Hauptprogramm zum Testen
int main()
{
    tKlasse Objekt;
    Objekt.SetData(7);
    Funktion(Objekt); // Hier wird der Kopierkonstruktor aktiv
    cout << Objekt.GetData() << endl;
}
