// Programm zur Demonstration der rekursiven Funktionen
// anhand eines Binrbaums
#include <iostream>
using namespace std;
#include <stdlib.h>

// Ein Baumelement besteht aus den Daten und zwei Zeigern
struct tBaum
{
    int Inhalt;
    tBaum * links;
    tBaum * rechts;
};

// Zeigt den Baum an, indem es sich selbst ber den linken Zweig
// aufruft, bis das Ende erreicht wurde. Dann zeigt die zuletzt
// aufgerufene Funktion "ihr" Element und ruft sich selbst ber
// den rechten Zeiger auf.
void ZeigeBaum(tBaum *Blatt)
{
    if (Blatt==0) return;    // Rekursionsende
    ZeigeBaum(Blatt->links); // Rekursionsaufruf
    cout << Blatt->Inhalt << endl; // Anzeige
    ZeigeBaum(Blatt->rechts); // Rekursionsaufruf
}

// Sucht rekursiv die Stelle, um den Inhalt einzusortieren
tBaum * Einfuegen(tBaum *Blatt, int Inhalt)
{
    if (Blatt==0) // Rekursionsende
    {
        // Position gefunden: Knoten erzeugen und initialisieren
        Blatt = new tBaum;
        Blatt->links = Blatt->rechts = 0;
        Blatt->Inhalt = Inhalt;
        return Blatt;
    }
    // Suche rekursiv die richtige Position
    if (Inhalt < Blatt->Inhalt)
    {
        Blatt->links = Einfuegen(Blatt->links, Inhalt);
    }
    else if (Inhalt > Blatt->Inhalt)
    {
        Blatt->rechts = Einfuegen(Blatt->rechts, Inhalt);
    }
    return Blatt;
}

// Rekursives Suchen im Baum
tBaum * Suchen(tBaum *Blatt, int Inhalt)
{
    if (Blatt==0) return 0; // Rekursionsende
    if (Inhalt < Blatt->Inhalt)
    {
        return Suchen(Blatt->links, Inhalt); // Rekursionsaufruf
    }
    else if (Inhalt > Blatt->Inhalt)
    {
        return Suchen(Blatt->rechts, Inhalt); // Rekursionsaufruf
    }
    return Blatt;
}

int main(int argc, char **argv)
{
    long neuWert;
    int anzahl = 20; // Anzahl der Elemente im Baum
    int start = 9;   // Startwert fr die Zufallsfunktion
    // Ermgliche dem Benutzer, die Vorgaben zu verndern
    if (argc>1)
    {
        anzahl = atoi(argv[1]);
    }
    if (argc>2)
    {
        start = atoi(argv[2]);
    }
    tBaum * Wurzel = 0; // Die Basis des Baums
    // Flle den Baum mit zuflligen Werten
    srand(start);
    for (int i=0; i<anzahl; i++)
    {
        neuWert = rand() % 100;
        cout << neuWert << " ";
        Wurzel = Einfuegen(Wurzel, neuWert);
    }
    cout << endl;
    // Zeige das Ergebnis
    ZeigeBaum(Wurzel);
    // Demonstriere das Suchen
    if (tBaum* erg = Suchen(Wurzel, 12)) 
    {
        cout << "gefunden: " << erg->Inhalt << endl;
    }
    else
    {
        cout << "12 nicht gefunden" << endl;
    }
}

